<?php
session_start();
// --- 1. AUTHENTICATION & PRINCIPAL ID FETCH ---
if(!isset($_SESSION['prnc_id']) || empty($_SESSION['prnc_id'])){ 
    echo "Not authorized"; 
    exit(); 
}

// Get the ID of the currently logged-in principal (who is the creator)
$logged_in_principal_id = $_SESSION['prnc_id'];

// --- 2. DATABASE CONNECTION (Using the correct credentials/DB) ---
$host = "localhost";
$user = "thevkin_schlprincdb";
$pass = "VK_AutSchlDb";
$db   = "thevkin_schlprincdb"; 

$adm_conn = mysqli_connect($host, $user, $pass, $db);
if(!$adm_conn){ 
    die("Admin DB Error: " . mysqli_connect_error()); 
}

// simple delete message show (using alert message styling for consistency)
$msg = "";
if(isset($_GET['msg'])) {
    $msg_text = htmlspecialchars($_GET['msg']);
    $msg = "<div class='alert success-alert'>{$msg_text}</div>";
}

// --- 3. MODIFIED SQL QUERY ---
$stmt = $adm_conn->prepare("SELECT * FROM school_admins WHERE created_by = ? ORDER BY created_at DESC");

if ($stmt === false) {
    die("Prepare failed: " . $adm_conn->error);
}

$stmt->bind_param("s", $logged_in_principal_id);
$stmt->execute();
$res = $stmt->get_result();

// Data array to hold results
$admins = [];
if($res) {
    while($r = $res->fetch_assoc()) {
        $admins[] = $r;
    }
}

$stmt->close();
mysqli_close($adm_conn);
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>School Admins List</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
/* --- Global Styles --- */
:root {
    --primary-color: #1a56db;
    --secondary-color: #172554;
    --bg-light: #f1f5f9; /* Lighter background */
    --text-dark: #333;
    --success-bg: #d4edda;
    --success-text: #155724;
}

body {
    font-family: 'Poppins', sans-serif;
    padding: 25px;
    background: var(--bg-light); 
    color: var(--text-dark);
}
.container {
    max-width: 1200px;
    margin: 0 auto;
}
h2 {
    color: var(--secondary-color);
    margin-bottom: 25px;
    font-weight: 700;
    padding-bottom: 10px;
}

/* --- Alerts --- */
.alert {
    padding: 12px 20px;
    border-radius: 8px;
    margin-bottom: 20px;
    font-weight: 500;
    animation: fadeIn 0.5s;
}
.success-alert {
    background-color: var(--success-bg);
    color: var(--success-text);
    border: 1px solid #c3e6cb;
}
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

/* --- Card List Base (Used for both Desktop and Mobile Cards) --- */
.admin-card-list {
    display: grid;
    gap: 20px;
}

/* --- Individual Card Styling --- */
.admin-card {
    background: #ffffff;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.admin-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
}

.card-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 1px solid #f0f0f0;
}
.card-header .photo {
    width: 65px;
    height: 65px;
    border-radius: 50%;
    object-fit: cover;
    border: 4px solid var(--primary-color);
    box-shadow: 0 0 0 2px #fff; /* Inner white ring */
}

.card-info h3 {
    font-size: 1.3rem;
    font-weight: 700;
    color: var(--primary-color);
    margin: 0;
}
.card-info p {
    font-size: 0.9rem;
    color: #6c757d;
    margin: 0;
}

.card-details-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr); /* Two columns for desktop */
    gap: 10px 20px;
    margin-bottom: 20px;
}

.card-detail {
    font-size: 0.95rem;
    padding: 5px 0;
    display: flex;
    align-items: center;
}
.card-detail i {
    color: var(--primary-color);
    margin-right: 10px;
    font-size: 1.1rem;
}
.card-detail strong {
    font-weight: 600;
    color: var(--text-dark);
    margin-right: 5px;
}
.card-detail span {
    color: #555;
    font-weight: 400;
}

/* --- Card Actions --- */
.card-actions {
    display: flex;
    justify-content: flex-end;
    gap: 15px;
    border-top: 1px solid #f0f0f0;
    padding-top: 15px;
}
.card-actions a {
    display: inline-flex;
    align-items: center;
    font-size: 0.9rem;
    padding: 8px 15px;
    border-radius: 6px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.2s;
}
.card-actions a i {
    margin-right: 8px;
}
.card-actions .edit {
    background-color: #eef4ff;
    color: var(--primary-color);
}
.card-actions .edit:hover {
    background-color: #dbe7ff;
}
.card-actions .delete {
    background-color: #fcebeb;
    color: #dc3545;
}
.card-actions .delete:hover {
    background-color: #fbd6d6;
}

/* --- Media Queries for Responsiveness --- */

/* Hide traditional table and show card list on all screens */
.table-container {
    display: none; 
}
.admin-card-list {
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); /* Desktop Grid */
}

@media (max-width: 992px) {
    .admin-card-list {
        grid-template-columns: 1fr; /* Single column on tablets/mobile */
    }
    /* Stack details vertically for better readability on tablets */
    .card-details-grid {
        grid-template-columns: 1fr; 
    }
}

@media (max-width: 576px) {
    body {
        padding: 10px; /* Reduced body padding */
    }
    .container {
        padding: 0 5px; /* Add slight horizontal padding to container */
    }
    h2 {
        text-align: center;
        margin-top: 10px;
    }
    .admin-card {
        padding: 15px; /* Reduced card padding */
    }
    .card-header .photo {
        width: 50px; /* Slightly smaller photo */
        height: 50px;
    }
    .card-info h3 {
        font-size: 1.1rem; /* Adjusted text size */
    }
    .card-detail {
        /* CRITICAL MOBILE FIX: Force label and value to stack vertically 
           or ensure they wrap cleanly by removing align-items center on small screens if wrapping is an issue.
           Let's use block display for better stacking on single column grid */
        display: block; 
        font-size: 0.9rem;
        line-height: 1.4;
        padding: 2px 0;
    }
    .card-detail i {
        display: none; /* Hide icons on smallest screen to save space, but keep the data clean */
    }
    .card-detail strong {
        display: inline-block; /* Ensure strong acts as a clear label */
        min-width: 80px; /* Gives structure */
        color: var(--primary-color);
        font-weight: 500;
    }
    .card-actions {
        justify-content: space-around; /* Distribute actions better */
        padding-top: 10px;
    }
    .card-actions a {
        font-size: 0.85rem;
        padding: 6px 10px;
    }
}

/* --- Fallback/No Admins Message Style --- */
.no-admins {
    background-color: #fff;
    color: #856404;
    border: 1px solid #ffeeba;
    text-align: center;
    font-size: 1.1rem;
    padding: 30px;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}
</style>
</head>
<body>
<div class="container">

<h2><i class="bi bi-people-fill"></i> Manage School Admins</h2>

<?php echo $msg; ?>

<?php if (empty($admins)): ?>
    <div class="alert no-admins">
        <i class="fas fa-info-circle"></i> No school admins have been created by your account yet.
    </div>
<?php else: ?>

    <div class="admin-card-list">
        <?php foreach ($admins as $r): 
            $photo = "uploads/".$r['photo'];
            if(!file_exists($photo) || empty($r['photo'])) {
                $photo = "uploads/default.png";
            }
            $created_at = htmlspecialchars(date('M d, Y', strtotime($r['created_at'])));
        ?>
        <div class="admin-card">
            <div class="card-header">
                <img src='<?php echo htmlspecialchars($photo); ?>' class='photo' alt='<?php echo htmlspecialchars($r['name']); ?>'>
                <div class="card-info">
                    <h3><?php echo htmlspecialchars($r['name']); ?></h3>
                    <p>Admin ID: <?php echo htmlspecialchars($r['id']); ?></p>
                </div>
            </div>
            
            <div class="card-details-grid">
                <div class="card-detail">
                    <i class="bi bi-person-fill"></i> <strong>Username:</strong> <span><?php echo htmlspecialchars($r['username']); ?></span>
                </div>
                <div class="card-detail">
                    <i class="bi bi-envelope-fill"></i> <strong>Email:</strong> <span><?php echo htmlspecialchars($r['email']); ?></span>
                </div>
                <div class="card-detail">
                    <i class="bi bi-clock-fill"></i> <strong>Created On:</strong> <span><?php echo $created_at; ?></span>
                </div>
                <div class="card-detail">
                    <i class="bi bi-person-badge-fill"></i> <strong>Creator ID:</strong> <span><?php echo htmlspecialchars($r['created_by']); ?></span>
                </div>
            </div>

            <div class="card-actions">
                <a href='edit_admin.php?id=<?php echo urlencode($r['id']); ?>' class='edit'>
                    <i class='fas fa-edit'></i> Edit
                </a>
                <a href='delete_admin.php?id=<?php echo urlencode($r['id']); ?>' class='delete' onclick="return confirm('Are you sure you want to permanently delete <?php echo htmlspecialchars($r['name']); ?>?')">
                    <i class='fas fa-trash-alt'></i> Delete
                </a>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

<?php endif; ?>

</div>
</body>
</html>