<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

session_start();

/* --------------------------------------------
   SESSION VALIDATION
-------------------------------------------- */
if (!isset($_SESSION['id']) || !isset($_SESSION['branch_id'])) {
    die("Session expired. Please login again.");
}

$principal_id = $_SESSION['id'];      // FIXED ✔
$branch_id    = $_SESSION['branch_id'];


/* --------------------------------------------
   DATABASE CONNECTIONS
-------------------------------------------- */
try {

    $db_principal = new PDO("mysql:host=localhost;dbname=thevkin_schlautdb", "thevkin_schlautdb", "VK_AutSchlDb");
    $db_principal->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $db_admins = new PDO("mysql:host=localhost;dbname=thevkin_schlprincdb", "thevkin_schlprincdb", "VK_AutSchlDb");
    $db_admins->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $db_teachers = new PDO("mysql:host=localhost;dbname=thevkin_schlteachdb", "thevkin_schlteachdb", "VK_AutSchlDb");
    $db_teachers->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $db_core = new PDO("mysql:host=localhost;dbname=thevkin_schlcoredb", "thevkin_schlcoredb", "VK_AutSchlDb");
    $db_core->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

} catch (PDOException $e) {
    die("DB Connection Failed: " . $e->getMessage());
}


/* --------------------------------------------
   DASHBOARD COUNTS
-------------------------------------------- */

// 1️⃣ Count School Admins
$q = $db_admins->prepare("SELECT COUNT(*) FROM school_admins WHERE created_by = ?");
$q->execute([$principal_id]);
$total_admins = $q->fetchColumn();


// 2️⃣ Count Teachers (handle missing table safely)
try {
    $q = $db_teachers->prepare("SELECT COUNT(*) FROM teachers WHERE created_by = ?");
    $q->execute([$principal_id]);
    $total_teachers = $q->fetchColumn();
} catch (PDOException $e) {
    $total_teachers = 0;  // SAFE FALLBACK ✔
}


// 3️⃣ Count Students
$q = $db_core->prepare("
    SELECT COUNT(*) 
    FROM students s
    JOIN classes c ON c.id = s.class_id
    WHERE c.branch_id = ?
");
$q->execute([$branch_id]);
$total_students = $q->fetchColumn();


// 4️⃣ Count Classes
$q = $db_core->prepare("SELECT COUNT(*) FROM classes WHERE branch_id = ?");
$q->execute([$branch_id]);
$total_classes = $q->fetchColumn();



/* --------------------------------------------
   FETCH LISTS
-------------------------------------------- */

// ➤ School Admin List
$q = $db_admins->prepare("SELECT * FROM school_admins WHERE created_by = ?");
$q->execute([$principal_id]);
$admins = $q->fetchAll(PDO::FETCH_ASSOC);


// ➤ Teacher List (safe fallback)
try {
    $q = $db_teachers->prepare("SELECT * FROM teachers WHERE created_by = ?");
    $q->execute([$principal_id]);
    $teachers = $q->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $teachers = []; // SAFE fallback
}


// ➤ Student List
$q = $db_core->prepare("
    SELECT s.*, c.class_name
    FROM students s
    JOIN classes c ON c.id = s.class_id
    WHERE c.branch_id = ?
");
$q->execute([$branch_id]);
$students = $q->fetchAll(PDO::FETCH_ASSOC);


// ➤ Class List
$q = $db_core->prepare("SELECT * FROM classes WHERE branch_id = ?");
$q->execute([$branch_id]);
$classes = $q->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html>
<head>
    <title>Principal Dashboard</title>
    <style>
        body { font-family: Arial; background:#f6f6f6; margin:0; padding:20px; }
        .cards { display:flex; gap:20px; margin-bottom:30px; }
        .card { background:white; padding:20px; border-radius:10px; width:200px; box-shadow:0 0 10px #ddd; }
        .card h3 { margin:0; font-size:18px; color:#444; }
        .card p { font-size:28px; margin:10px 0 0; color:#111; }

        table { width:100%; border-collapse:collapse; margin-top:20px; background:white; }
        th, td { padding:10px; border-bottom:1px solid #ddd; }
        th { background:#eee; text-align:left; }
        h2 { margin-top:40px; }
    </style>
</head>
<body>

<h1>Principal Dashboard</h1>

<!-- DASHBOARD CARDS -->
<div class="cards">
    <div class="card">
        <h3>School Admins</h3>
        <p><?= $total_admins ?></p>
    </div>

    <div class="card">
        <h3>Teachers</h3>
        <p><?= $total_teachers ?></p>
    </div>

    <div class="card">
        <h3>Students</h3>
        <p><?= $total_students ?></p>
    </div>

    <div class="card">
        <h3>Classes</h3>
        <p><?= $total_classes ?></p>
    </div>
</div>


<!-- SCHOOL ADMIN LIST -->
<h2>School Admins</h2>
<table>
    <tr><th>Name</th><th>Email</th><th>Username</th><th>Created At</th></tr>
    <?php foreach ($admins as $a): ?>
    <tr>
        <td><?= $a['name'] ?></td>
        <td><?= $a['email'] ?></td>
        <td><?= $a['username'] ?></td>
        <td><?= $a['created_at'] ?></td>
    </tr>
    <?php endforeach; ?>
</table>


<!-- TEACHER LIST -->
<h2>Teachers</h2>
<table>
    <tr><th>Name</th><th>Email</th><th>Username</th><th>Phone</th><th>Created At</th></tr>
    <?php foreach ($teachers as $t): ?>
    <tr>
        <td><?= $t['first_name'] . " " . $t['last_name'] ?></td>
        <td><?= $t['email'] ?></td>
        <td><?= $t['username'] ?></td>
        <td><?= $t['phone'] ?></td>
        <td><?= $t['created_at'] ?></td>
    </tr>
    <?php endforeach; ?>
</table>


<!-- STUDENT LIST -->
<h2>Students</h2>
<table>
    <tr><th>Name</th><th>Username</th><th>Class</th><th>Roll No</th><th>Parent Name</th></tr>
    <?php foreach ($students as $s): ?>
    <tr>
        <td><?= $s['name'] ?></td>
        <td><?= $s['username'] ?></td>
        <td><?= $s['class_name'] ?></td>
        <td><?= $s['roll_no'] ?></td>
        <td><?= $s['parent_name'] ?></td>
    </tr>
    <?php endforeach; ?>
</table>


<!-- CLASS LIST -->
<h2>Classes</h2>
<table>
    <tr><th>Class Name</th><th>Created At</th></tr>
    <?php foreach ($classes as $c): ?>
    <tr>
        <td><?= $c['class_name'] ?></td>
        <td><?= $c['created_at'] ?></td>
    </tr>
    <?php endforeach; ?>
</table>

</body>
</html>
