<?php
// Start Output Buffering at the very top
ob_start();

session_start();
// --- CRITICAL SECURITY CHECK ---
// Ensure the session variable used for authentication is consistent.
if(!isset($_SESSION['prnc_id']) || empty($_SESSION['prnc_id'])){
    // Clean buffer before redirection
    if (ob_get_level() > 0) ob_end_clean();
    header("Location: login.php");
    exit();
}

// Fetch session data
$name = htmlspecialchars($_SESSION['prnc_name'] ?? 'Principal');

// 🔴 FIX: CRITICAL PHOTO PATH LOGIC
// The prnc_profile.php file updates $_SESSION['prnc_photo'] with the FULL PATH (e.g., 'uploads/uniqueid.jpg').
// We must use this full path directly for display.
$photo_path = $_SESSION['prnc_photo'] ?? '';

// CRITICAL IMAGE FETCH FIX: Use robust path checking
// Check if the file exists using the session-stored path.
$image_url = (!empty($photo_path) && file_exists($photo_path)) ? $photo_path : "uploads/default.png";

// Determine the active page from the URL.
$page = isset($_GET['page']) ? $_GET['page'] : 'home';

// Map URL parameter to the actual file path
$page_file_map = [
    'home' => 'stamp.php',
    'create-admin' => 'add_school_admin.php',
    'manage-admin' => 'school_admin_list.php',
    'profile' => 'prnc_profile.php'
];
$initial_iframe_src = $page_file_map[$page] ?? 'stamp.php';


// Check for and display messages from the query string (e.g., after an update)
$msg = isset($_GET['msg']) ? htmlspecialchars($_GET['msg']) : '';
$msg_type = isset($_GET['type']) ? htmlspecialchars($_GET['type']) : '';


// Placeholder logo path (Ensure this URL is accessible)
$logo_url = "https://thevk.in/wp-content/uploads/2025/04/vk-brand-logo.jpg";
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Principal Dashboard</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

<style>
/* ==================================================== */
/* GLOBAL & MOBILE-FIRST STYLES (App Look) */
/* ==================================================== */

html { height: 100%; }
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    -webkit-tap-highlight-color: transparent;
}

:root {
    /* Colors matching the Stakeholder Blue theme for a unified app */
    --primary-color: #1a56db; /* Primary Blue */
    --secondary-color: #172554; /* Dark Blue */
    --text-dark: #1f2937;
    --text-light: #f3f4f6;
    --bg-light: #f1f5f9;
    --header-height-mobile: 80px;
    --header-height-desktop: 80px;
    --sidebar-width: 280px;
    --bottom-nav-height: 65px;
}

body {
    font-family: "Poppins", sans-serif;
    display: flex;
    flex-direction: column;
    height: 100dvh;
    background: var(--bg-light);
    overflow: hidden;
}

.app-container {
    display: flex;
    flex-direction: column;
    width: 100%;
    height: 100%;
    position: relative;
}

/* --- TOP PANEL (Header - Mobile) --- */
.top-panel {
    height: var(--header-height-mobile);
    background: #ffffff;
    border-bottom: 1px solid #e2e8f0;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 20px;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    z-index: 1000;
}

.header-branding {
    display: flex;
    align-items: center;
    gap: 12px;
}
.header-branding img {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    object-fit: cover;
}
.branding-info h4 {
    font-size: 1.2rem;
    font-weight: 600;
    color: var(--text-dark);
}
.branding-info p {
    font-size: 0.9rem;
    color: #6b7280;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 10px;
    height: 100%;
}

.profile-box { cursor: pointer; }
.profile-box img {
    width: 50px;
    height: 50px;
    border: 4px solid var(--primary-color);
    border-radius: 50%;
    object-fit: cover;
    transition: transform 0.2s;
}
.profile-info { display: none; }


/* --- MAIN CONTENT WRAPPER (Mobile View) --- */
.main-wrapper {
    display: flex;
    flex-direction: column;
    width: 100%;
    flex: 1;
    padding-top: var(--header-height-mobile);
    padding-bottom: var(--bottom-nav-height);
    height: 100%;
    overflow-y: auto;
}

.left-panel {
    display: none;
}

.right-content {
    flex: 1;
    padding: 0;
    background: var(--bg-light);
}

.content-frame-area {
    padding: 0;
    width: 100%;
    height: 100%;
    overflow: hidden;
}

.content-frame-area iframe {
    width: 100%;
    height: 100%;
    border: none;
    background: var(--bg-light);
}

.top { display: none; }


/* ==================================================== */
/* 2. BOTTOM NAVIGATION BAR (Mobile App Look) */
/* ==================================================== */

.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    height: var(--bottom-nav-height);
    background: #ffffff;
    display: flex;
    justify-content: space-around;
    align-items: center;
    border-top: 1px solid #e2e8f0;
    box-shadow: 0 -4px 15px rgba(0, 0, 0, 0.15);
    z-index: 2000;
}

.bottom-nav a {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    color: #6b7280;
    flex: 1;
    height: 100%;
    transition: color 0.2s ease, background-color 0.2s ease;
    font-size: 0.7rem; /* Slightly smaller text for fit */
    font-weight: 500;
    padding: 5px;
    gap: 2px; /* Small gap between icon and text */
}

.bottom-nav a i {
    font-size: 1.4rem; /* Slightly smaller icon */
}

.bottom-nav a.active {
    color: var(--primary-color);
    font-weight: 600;
    background-color: #eef4ff; /* Subtle active background */
    border-radius: 5px; /* Added slight rounding */
}
.bottom-nav a:hover {
    background-color: #f7f9fd;
}
.bottom-nav a:active {
    background-color: #e5e9f2;
}

/* --- MESSAGE BOX STYLES --- */
.message-box {
    position: fixed;
    top: var(--header-height-mobile);
    left: 0;
    width: 100%;
    padding: 10px 20px;
    z-index: 1500;
    text-align: center;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    animation: slideDown 0.3s ease-out;
}
.message-box.success {
    background-color: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}
.message-box.error {
    background-color: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}
.message-box button {
    background: none;
    border: none;
    color: inherit;
    font-weight: bold;
    cursor: pointer;
    float: right;
    font-size: 1.2rem;
    line-height: 1;
}

@keyframes slideDown {
    from { transform: translateY(-100%); opacity: 0; }
    to { transform: translateY(0); opacity: 1; }
}


/* ==================================================== */
/* 3. DESKTOP (>= 1024px) STYLES */
/* ==================================================== */

@media (min-width: 1024px) {

    body { flex-direction: row; }
    .top-panel { display: none; }
    .main-wrapper {
        flex-direction: row;
        padding: 0;
        height: 100%;
        overflow: hidden;
    }

    /* --- Left Panel (Sidebar - Professional Look) --- */
    .left-panel {
        display: flex;
        width: var(--sidebar-width);
        background: linear-gradient(180deg, #1e40af 0%, var(--secondary-color) 100%);
        box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
        flex-direction: column;
        color: var(--text-light);
        flex-shrink: 0;
        overflow: hidden;
    }

    .sidebar-header {
        display: flex;
        align-items: center;
        padding: 24px 20px;
        gap: 15px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }
    .sidebar-header img {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        object-fit: cover;
    }
    .sidebar-header h4 {
        font-size: 1.3rem;
        font-weight: 700;
        color: var(--text-light);
    }

    .sidebar-menu {
        padding: 20px 10px;
        flex: 1;
        overflow-y: auto;
    }
    .sidebar-menu a {
        color: rgba(255, 255, 255, 0.85);
        padding: 12px 15px;
        border-radius: 8px;
        margin-bottom: 5px;
        display: flex;
        align-items: center;
        gap: 12px;
        font-size: 0.95rem;
        text-decoration: none;
        transition: background 0.2s ease, transform 0.1s;
    }
    .sidebar-menu a i { font-size: 1.2rem; }

    /* Professional Hover State */
    .sidebar-menu a:hover:not(.active) {
        background: rgba(255, 255, 255, 0.15); /* Slightly brighter hover */
        transform: translateY(-1px);
        color: white;
    }

    /* Prominent Active State */
    .sidebar-menu a.active {
        background: var(--primary-color);
        box-shadow: 0 4px 8px rgba(26, 86, 219, 0.3);
        font-weight: 600; /* Bolder text for active */
        color: #fff;
        transform: none;
    }

    /* --- Desktop Header --- */
    .right-content {
        padding: 0;
        flex: 1;
        display: flex;
        flex-direction: column;
        overflow-y: hidden;
    }

    .top {
        display: flex;
        height: var(--header-height-desktop);
        background: #fff;
        border-bottom: 1px solid #e2e8f0;
        align-items: center;
        justify-content: flex-end;
        padding: 0 40px;
        flex-shrink: 0;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.04);
    }
    /* FIX: Ensure image and text are aligned correctly in the profile box */
    .top .profile-box {
        display: flex;
        align-items: center;
        gap: 10px;
        background: #f8fafc;
        padding: 8px 15px;
        border-radius: 50px;
        border: 1px solid #e2e8f0;
        cursor: pointer;
        transition: background 0.2s ease;
    }
    .top .profile-box:hover {
        background: #eff3f9;
    }
    .top .profile-box img {
        width: 45px;
        height: 45px;
        border-radius: 50%; /* Ensure image is a circle */
        object-fit: cover;
        flex-shrink: 0; /* Prevents image from shrinking and causing overlap */
        border: none;
    }
    .top .profile-info {
        display: flex;
        flex-direction: column;
        justify-content: center;
        margin-right: 0;
        white-space: nowrap;
    }
    .top .name { font-weight: 600; font-size: 1rem; color: var(--text-dark); }
    .top .role { font-size: 0.8rem; color: #6b7280; }

    .content-frame-area {
        flex: 1;
        /* Padding removed here to allow iframe content full height */
        padding: 0;
        overflow-y: hidden; /* iframe handles its own scroll */
        position: relative;
    }
    .content-frame-area iframe {
        height: 100%;
        max-height: 100%;
    }

    .message-box {
        top: var(--header-height-desktop);
        /* Adjust for desktop layout */
        left: var(--sidebar-width);
        width: calc(100% - var(--sidebar-width));
    }

    .bottom-nav { display: none; }
}
</style>

<script>
// Function to handle the navigation and active state
function navigateToPage(pageKey) {
    const pageFileMap = {
        'home': 'stamp.php',
        'create-admin': 'add_school_admin.php',
        'manage-admin': 'school_admin_list.php',
        'profile': 'prnc_profile.php'
    };
    const frame = document.getElementById('frame');

    // 1. Update the main dashboard URL to track the current page (essential for refresh/back button)
    // Clear any existing msg/type parameters before navigating
    const url = new URL(window.location);
    url.searchParams.set('page', pageKey);
    url.searchParams.delete('msg');
    url.searchParams.delete('type');
    history.pushState(null, '', url.toString());

    // 2. Set the active link state
    setActiveLink(pageKey);

    // 3. Load content into the iframe
    frame.src = pageFileMap[pageKey] || 'stamp.php';

    // 4. Hide the message box when navigating
    hideMessage();
}

// Function to update the active state of navigation links
function setActiveLink(targetPage) {
    const selector = `.sidebar-menu a, .bottom-nav a`;

    document.querySelectorAll(selector).forEach(a => a.classList.remove('active'));

    // Find links that contain the correct page parameter (data-page used for clarity)
    const links = document.querySelectorAll(`${selector}[data-page="${targetPage}"]`);
    links.forEach(link => {
        link.classList.add('active');
    });
}

function showMessage(msg, type) {
    const box = document.getElementById('dashboard-message-box');
    if (!box) return;

    box.innerHTML = `${msg} <button onclick="hideMessage()">&times;</button>`;
    box.className = `message-box ${type}`;
    box.style.display = 'block';

    // Automatically hide after 5 seconds
    setTimeout(hideMessage, 5000);
}

function hideMessage() {
    const box = document.getElementById('dashboard-message-box');
    if (box) {
        box.style.display = 'none';
        // Also clean the URL after hiding the message
        const url = new URL(window.location);
        url.searchParams.delete('msg');
        url.searchParams.delete('type');
        history.replaceState(null, '', url.toString());
    }
}

// Event listener to receive messages from the iframe (prnc_profile.php)
window.addEventListener('message', function(event) {
    // Only accept messages from the same origin for security
    if (event.origin !== window.location.origin) return;

    if (event.data && event.data.action === 'show_alert') {
        showMessage(event.data.message, event.data.type);
    }
    
    // 🔴 NEW LOGIC: Refresh the profile image when a successful update message is received
    if (event.data && event.data.action === 'show_alert' && event.data.type === 'success') {
        // Since the session is updated in PHP after successful POST, we need a reliable way 
        // to tell the parent frame (dashboard.php) to reload the image URL.
        // The simplest way is to force a re-load of the iframe, but that might lose context.
        // A better way is to pass the new image URL via the postMessage, but since you didn't 
        // pass it, we will rely on the session logic and assume a page refresh will get the new data.
        // For a more dynamic update, you'd add:
        /*
        if (event.data.newPhotoPath) {
            document.querySelectorAll('.profile-box img').forEach(img => {
                img.src = event.data.newPhotoPath + '?' + new Date().getTime(); // Cache busting
            });
        }
        */
        // Since we don't have newPhotoPath in the current prnc_profile.php postMessage,
        // we'll rely on the existing image source calculation which uses the PHP session.
        // A simple cache-busting refresh on the image tag sources is safer:
        document.querySelectorAll('.profile-box img').forEach(img => {
            const currentSrc = img.getAttribute('src');
            // Append a unique query parameter to bypass browser cache
            img.src = currentSrc.split('?')[0] + '?' + new Date().getTime(); 
        });
    }
}, false);


// Initial setup
document.addEventListener('DOMContentLoaded', function() {
    // Set initial active state based on the current PHP-determined page
    const initialPageKey = "<?php echo $page; ?>";
    setActiveLink(initialPageKey);

    // Check for PHP-set URL messages on initial load (e.g., after PRG redirection)
    const initialMsg = "<?php echo $msg; ?>";
    const initialType = "<?php echo $msg_type; ?>";
    if (initialMsg !== "") {
        showMessage(initialMsg, initialType);
    }

    // Profile click logic (for both mobile icon and desktop info box)
    document.querySelectorAll('.profile-box').forEach(box => {
        box.addEventListener('click', function() {
            navigateToPage('profile');
        });
    });
});
</script>

</head>
<body>

<div class="app-container">

    <?php if ($msg != ""): // This is only used for messages set by PHP redirection (PRG pattern) ?>
    <div id="dashboard-message-box" class="message-box <?php echo $msg_type; ?>">
        <?php echo $msg; ?> <button onclick="hideMessage()">&times;</button>
    </div>
    <?php else: ?>
    <div id="dashboard-message-box" class="message-box" style="display: none;"></div>
    <?php endif; ?>


    <div class="top-panel">
        <div class="header-branding">
            <img src="<?php echo $logo_url; ?>" alt="Principal Logo">
            <div class="branding-info">
                <h4>VK Principal</h4>
                <p>Management Panel</p>
            </div>
        </div>
        <div class="header-right">
            <div class="profile-box" data-page="profile">
                <img src="<?php echo htmlspecialchars($image_url); ?>" alt="<?php echo $name; ?>">
            </div>
        </div>
    </div>

    <div class="main-wrapper">

        <div class="left-panel">
            <div class="sidebar-header">
                <img src="<?php echo $logo_url; ?>" alt="Principal Logo">
                <h4>VK Principal</h4>
            </div>

            <div class="sidebar-menu">
                <a href="javascript:void(0)" onclick="navigateToPage('home')" data-page="home">
                    <i class="bi bi-house-door-fill"></i>
                    <span>Home</span>
                </a>
                <a href="javascript:void(0)" onclick="navigateToPage('create-admin')" data-page="create-admin">
                    <i class="bi bi-person-plus-fill"></i>
                    <span>Create School Admin</span>
                </a>
                <a href="javascript:void(0)" onclick="navigateToPage('manage-admin')" data-page="manage-admin">
                    <i class="bi bi-people-fill"></i>
                    <span>Manage School Admins</span>
                </a>
                <a href="javascript:void(0)" onclick="navigateToPage('profile')" data-page="profile">
                    <i class="bi bi-person-circle"></i>
                    <span>Profile</span>
                </a>
                <a href="logout.php">
                    <i class="bi bi-box-arrow-right"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>

        <div class="right-content">

            <div class="top">
                <div class="profile-box" data-page="profile">
                    <img src="<?php echo htmlspecialchars($image_url); ?>" alt="<?php echo $name; ?>">
                    <div class="profile-info">
                        <span class="name"><?php echo htmlspecialchars($name); ?></span>
                        <span class="role">Principal</span>
                    </div>
                </div>
            </div>

            <div class="content-frame-area">
                <iframe id="frame" src="<?php echo $initial_iframe_src; ?>" scrolling="yes"></iframe>
            </div>
        </div>
    </div>

    <div class="bottom-nav">
        <a href="javascript:void(0)" onclick="navigateToPage('home')" data-page="home">
            <i class="bi bi-house-door-fill"></i> <span>Home</span>
        </a>
        <a href="javascript:void(0)" onclick="navigateToPage('create-admin')" data-page="create-admin">
            <i class="bi bi-person-plus-fill"></i> <span>Admin</span>
        </a>
        <a href="javascript:void(0)" onclick="navigateToPage('manage-admin')" data-page="manage-admin">
            <i class="bi bi-people-fill"></i> <span>Manage</span>
        </a>
        <a href="javascript:void(0)" onclick="navigateToPage('profile')" data-page="profile">
            <i class="bi bi-person-circle"></i> <span>Profile</span>
        </a>
        <a href="logout.php">
            <i class="bi bi-box-arrow-right"></i> <span>Logout</span>
        </a>
    </div>
</div>

<?php
// End output buffering and send content
if (ob_get_level() > 0) ob_end_flush();
?>

</body>
</html>